{include file="left.tpl"}

<script src="../modules/editors/tinymce/tinymce.min.js"></script>
<script>
	jQuery(document).ready(function($)
	{
		init_tinymce('text', 'lite', '{file_manager_theme}', '{file_manager}', '<? echo md5($conf->code); ?>');

		changeFuncServ();

		$('#add_img_form').submit(function (event)
		{
			NProgress.start();

			event.preventDefault();

			var data = new FormData($('#add_img_form')[0]);

			$.ajax({
				type: 'POST',
				url: '../ajax/actions_a.php',
				data: data,
				contentType: false,
				processData: false,
			}).done(function(data){
				NProgress.done();

				$('#img_result').html(data);
				$('#add_img_form')[0].reset();
			});
		});
	});

	function changeFuncServ()
	{
		var selectBox = document.getElementById('server');

		select_ban_type(selectBox.options[selectBox.selectedIndex].title);
	}

	function find_bans()
	{
		NProgress.start();

		$.ajax({
			type: 'POST',
			url: '../ajax/actions_a.php',
			data: 'phpaction=1&find_bans=1&token='+$('#token').val()+'&ban='+encodeURIComponent($('#nick_db').val().trim())+'&server='+$('#server').val(),
			dataType: "json",
			success: function(result)
			{
				NProgress.done();

				if(result.status == 1)
				{
					$('#baninfo').show();
					$('#baninfo tbody').html(result.data);
					$('#baninfo_full').empty();
					$('#dop').attr('class', 'disp-n');

					setTimeout(show_ok, 500);
				} else {
					setTimeout(show_error, 500);

					$('#baninfo').html(result.data);
				}
			}
		});
	}

	function search_fullban(ban, server)
	{
		NProgress.start();

		$.ajax({
			type: 'POST',
			url: '../ajax/actions_a.php',
			data: 'phpaction=1&search_ban2=1&token='+encodeURIComponent($('#token').val())+'&ban='+ban+'&server='+server,
			success: function(data)
			{
				NProgress.done();

				$('#baninfo').hide();
				$('#baninfo_full').html(data);

				setTimeout(show_ok, 500);
			}
		});
	}
</script>

{script}

<div class="content float-right">
	<div class="block">
		<div class="header">Информация</div>
		<div class="block-content">
			<div class="bs-callout bs-callout-info bs-mini-info">
				<p>Заполните поля достоверной информацией, постарайтесь в качестве доказательства приложить скриншоты и ссылку на демо. После создания заявки, ожидайте решения администрации.</p>
			</div>
		</div>
	</div>
	<div class="block">
		<div class="header">Подать заявку на разбан</div>
		<div class="block-content">
			<div class="form-input">
				<label for="server">Игровой сервер</label>
				<select id="server" onchange="changeFuncServ()">
					{servers}
				</select>
			</div>
			<div class="disp-n" id="none">
				<div class="form-input">
					<label for="nick">Ник на сервере</label>
					<input type="text" id="nick" maxlength="32" autocomplete="off">
				</div>
				<div class="form-input">
					<label for="reason">Причина бана</label>
					<input type="text" id="reason" maxlength="250" autocomplete="off">
				</div>
			</div>
			<div class="disp-n" id="db">
				<div class="form-input">
					<label for="nick_db">Ваш идентификатор</label>
					<input type="text" id="nick_db" maxlength="32" autocomplete="off" placeholder="Введите ник / SteamID / IP">
				</div>
				<div class="message-send">
					<div class="btn float-left" onclick="find_bans()">Выполнить поиск</div>
				</div>
				<div class="clear"></div>

				<table id="baninfo" class="table-list m-t-25 disp-n">
					<thead>
						<tr>
							<th align="left" width="45%">Ник</th>
							<th align="left">Причина</th>
							<th align="left" width="15%">Дата окончания</th>
							<th align="center" width="1%">Действие</th>
						</tr>
					</thead>
					<tbody></tbody>
				</table>
				<div id="baninfo_full"></div>
			</div>
			<div class="disp-n" id="dop">
				<div class="space"></div>

				<div class="form-input">
					<label>Пояснение</label>
				</div>
				<textarea id="text" maxlenght="2000"></textarea>

				<div class="form-input">
					<label>Скриншоты</label>
				</div>
				<form enctype="multipart/form-data" action="ajax/actions_a.php" method="post" id="add_img_form">
					<input type="hidden" id="token" name="token" value="{token}">
					<input type="hidden" id="add_ban_img" name="add_ban_img" value="1">
					<input type="hidden" id="phpaction" name="phpaction" value="1">
					<input type="hidden" id="counter" name="counter" value="0">
					<input class="imginput" type="file" id="ban_img" accept="image/*" name="ban_img">
					<div class="space m-t-5"></div>
					<div class="btn float-left" onclick="$('#add_img_form').submit()">Загрузить</div>
					<div id="img_result" class="float-right"></div>
				</form>
				<input value="" type="hidden" id="screens" autocomplete="off">

				<div class="clear"></div>

				<div class="bs-callout bs-callout-info bs-mini-info m-t-5"><p>Максимальное количество прикрепляемых скриншотов: 5шт.</p></div>

				<div class="upload-image m-t-5" id="imgs"></div>

				<div class="clear"></div>

				<div class="form-input">
					<label for="demo">Ссылка на демо</label>
					<input type="text" id="demo" maxlength="250" autocomplete="off">
				</div>
				<div class="message-send">
					<div class="btn green float-left" onclick="add_ban()">Подать</div>
					<div class="float-right" id="new_result"></div>
				</div>
				<div class="clear"></div>
			</div>
		</div>
	</div>
</div>